#ifndef _IBOX_HLSL_
#define _IBOX_HLSL_
	// Ray-Box intersection, by convertig the ray to the local space of the box.
	// Returns: t
	float iBox(in float3 ro, in float3 rd, in int bboxIdx) 
	{
	  // convert from ray to box space
	  // mul() operands order matters!!!
	  float3 rdd = (mul(float4(rd, 0.0), gBoundingBoxes[bboxIdx].txx)).xyz;
	  float3 roo = (mul(float4(ro, 1.0), gBoundingBoxes[bboxIdx].txx)).xyz;

	  // ray-box intersection in box space
	  float3 m = rcp(rdd);
	  float3 n = m * roo;
	  float3 k = abs(m) * gBoundingBoxes[bboxIdx].rad;

	  float3 t1 = -n - k;
	  float3 t2 = -n + k;

	  float tN = max(max(t1.x, t1.y), t1.z);
	  float tF = min(min(t2.x, t2.y), t2.z);

	  /*if (tN > tF || tF < 0.0)
	  {
		return -1.0;
	  }*/

	  return lerp(tN, -1.0, max(sign(tN - tF - 0.00001), 0.0) * max(sign(tF + 0.00001), 0.0));
	}
#endif // _IBOX_HLSL_